#include <stdlib.h>
#include "tif_config.h"

#include "tiffio.h"
#include "img2ibitmap.h"

ibitmap* tiff2ibitmap(const char* infilename)
{
	TIFF *img;
	uint32	width, height, *buf = NULL;
	uint16  bitsPerSample, samplesPerPixel;
	ibitmap *bit = NULL;
	unsigned char r, g, b;
	int i, j;

	if ((img = TIFFOpen(infilename, "r"))) {
		TIFFGetField(img, TIFFTAG_IMAGEWIDTH, &width);
		TIFFGetField(img, TIFFTAG_IMAGELENGTH, &height);
		TIFFGetField(img, TIFFTAG_BITSPERSAMPLE, &bitsPerSample);
		TIFFGetField(img, TIFFTAG_SAMPLESPERPIXEL, &samplesPerPixel);
		if ((buf = (uint32*)malloc(width*height*sizeof(uint32)))) {
			if (TIFFReadRGBAImageOriented(img, width, height, buf, ORIENTATION_TOPLEFT, 0) == 1) {
				if ((bit = new_ibitmap(width, height, get_opt_ibitmap_depth(bitsPerSample*samplesPerPixel)))) {
					for (j = 0; j < height; j++) {
						for (i = 0; i < width; i++) {
							r = TIFFGetR(buf[j*width+i]);
							g = TIFFGetG(buf[j*width+i]);
							b = TIFFGetB(buf[j*width+i]);
							setRGB(bit, i, j, r, g, b, 0);
						}
					}
				}
			}
			free(buf);
		}
		TIFFClose(img);
	}

	return bit;
}
