#ifndef ARCHIVEHANDLER_H_
#define ARCHIVEHANDLER_H_

/* This is an abstract class defining the interface used by ImageMng
 * to access files in an archive. */

#include <string>
#include <vector>

class ArchiveHandler {
	public:
		void SetPassword(char *password) { _passwd = password; }
		/* The following returns non-zero if the archive couldn't be opened. */
		virtual int Open(std::string& path, std::vector<std::string>& files) = 0;
		/* The following returns non-zero if a password is required. */
		virtual int UnpackFile(std::string& name, std::string &outname) = 0;
		virtual ~ArchiveHandler() { _dir.clear(); _passwd.clear(); }

	protected:
		ArchiveHandler(std::string& outdir) : _dir(outdir) {}
		std::string _dir;
		std::string _passwd;
};

#endif /* ARCHIVEHANDLER_H_ */
